{********************************************
; File: IntMath.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT INTMATH;
INTERFACE
USES TYPES;
CONST


{ Error Codes }
imBadInptParam = $0B01;  { bad input parameter }
imIllegalChar = $0B02;  { Illegal character in string }
imOverflow = $0B03;  { integer or long integer overflow }
imStrOverflow = $0B04;  { string overflow }

{ Limit Values }
minLongint = $80000000;  { minimum negative signed long integer }
minFrac = $80000000;  { pinned value for negative Frac overflow }
minFixed = $80000000;  { pinned value for negative Fixed overflow }
minInt = $8000;  { Minimum negative signed integer }
maxInt = $7FFF;  { Maximum positive signed integer }
maxUInt = $FFFF;  { Maximum positive unsigned integer }
maxLongint = $7FFFFFFF;  { maximum positive signed Longint }
maxFrac = $7FFFFFFF;  { pinned value for positive Frac overflow }
maxFixed = $7FFFFFFF;  { pinned value for positive Fixed overflow }
maxULong = $FFFFFFFF;  { maximum unsigned Long }
TYPE
IntDivRecPtr = ^IntDivRec;
IntDivRec = RECORD
    quotient : Integer; { quotient from SDivide }
    remainder : Integer; { remainder from SDivide }
END;
LongDivRecPtr = ^LongDivRec;
LongDivRec = RECORD
    quotient : Longint; { Quotient from LongDiv }
    remainder : Longint; { remainder from LongDiv }
END;
DivRecPtr = ^DivRec; (* for backward compatability *)
DivRec = LongDivRec;
LongMulRecPtr = ^LongMulRec;
LongMulRec = RECORD
    lsResult : Longint; { low 2 words of product }
    msResult : Longint; { High 2 words of product }
END;
WordDivRecPtr = ^WordDivRec;
WordDivRec = RECORD
    quotient : Integer; { Quotient from UDivide }
    remainder : Integer; { remainder from UDivide }
END;
FUNCTION Dec2Int ( strPtr:Ptr; strLength:Integer; signedFlag:Boolean) : Integer ;
FUNCTION Dec2Long ( strPtr:Ptr; strLength:Integer; signedFlag:Boolean) : Longint ;
FUNCTION Fix2Frac ( fixedValue:Fixed) : Frac ;
FUNCTION Fix2Long ( fixedValue:Fixed) : Longint ;
PROCEDURE Fix2X ( fixedValue:Fixed;VAR extendPtr:Extended)  ;
FUNCTION FixATan2 ( input1:Longint; input2:Longint) : Fixed ;
FUNCTION FixDiv ( dividend:Longint; divisor:Longint) : Fixed ;
FUNCTION FixMul ( multiplicand:Fixed; multiplier:Fixed) : Fixed ;
FUNCTION FixRatio ( numerator:Integer; denominator:Integer) : Fixed ;
FUNCTION FixRound ( fixedValue:Fixed) : Integer ;
FUNCTION Frac2Fix ( fracValue:Frac) : Fixed ;
PROCEDURE Frac2X ( fracValue:Frac;VAR extendPtr:Extended)  ;
FUNCTION FracCos ( angle:Fixed) : Frac ;
FUNCTION FracDiv ( dividend:Longint; divisor:Longint) : Frac ;
FUNCTION FracMul ( multiplicand:Frac; multiplier:Frac) : Frac ;
FUNCTION FracSin ( angle:Fixed) : Frac ;
FUNCTION FracSqrt ( fracValue:Frac) : Frac ;
FUNCTION Hex2Int ( strPtr:Ptr; strLength:Integer) : Integer ;
FUNCTION Hex2Long ( strPtr:Ptr; strLength:Integer) : Longint ;
FUNCTION HexIt ( intValue:Integer) : Longint ;
FUNCTION HiWord ( longValue:Longint) : Integer ;
PROCEDURE IMBootInit   ;
PROCEDURE IMReset   ;
PROCEDURE IMShutDown   ;
PROCEDURE IMStartUp   ;
FUNCTION IMStatus  : Boolean ;
FUNCTION IMVersion  : Integer ;
PROCEDURE Int2Dec ( wordValue:Integer; strPtr:Ptr; strLength:Integer; signedFlag:Boolean)  ;
PROCEDURE Int2Hex ( intValue:Integer; strPtr:Ptr; strLength:Integer)  ;
PROCEDURE Long2Dec ( longValue:Longint; strPtr:Ptr; strLength:Integer; signedFlag:Boolean)  ;
FUNCTION Long2Fix ( longValue:Longint) : Fixed ;
PROCEDURE Long2Hex ( longValue:Longint; strPtr:Ptr; strLength:Integer)  ;
FUNCTION LongDivide ( dividend:Longint; divisor:Longint) : LongDivRec ;
FUNCTION LongMul ( multiplicand:Longint; multiplier:Longint) : LongMulRec ;
FUNCTION LoWord ( longValue:Longint) : Integer ;
FUNCTION Multiply ( multiplicand:Integer; multiplier:Integer) : Longint ;
FUNCTION SDivide ( dividend:Integer; divisor:Integer) : IntDivRec ;
FUNCTION UDivide ( dividend:Integer; divisor:Integer) : WordDivRec ;
FUNCTION X2Fix ( extendPtr:ExtendedPtr) : Fixed ;
FUNCTION X2Frac ( extendPtr:ExtendedPtr) : Frac ;
IMPLEMENTATION
END.
